From: David Leaver <leaver@alphalink.com.au>
Subject: Eastern Front EFT18M.ASM
Date: Wednesday, December 02, 1998 12:20 PM

10 ;EFT VERSION 1.8M (MAINLINE) 11/30/81 COPYRIGHT CHRIS CRAWFORD 1981
20 ;
30 ;Page zero RAM
40 DLSTPT=$B0 Zero page pointer to display list
50 CORPS=$B4
60  *=$BE
70 CHUNKX *=*+1 cursor coordinates (pixel frame)
80 CHUNKY *=*+1
90 ;
0100 ;These locations are for the mainline routines
0110 ;
0120 MAPPTR *=*+2
0130 ARMY *=*+1
0140 UNITNO *=*+1
0150 DEFNDR *=*+1
0160 TEMPR *=*+1
0170 TEMPZ *=*+1
0180 ACCLO *=*+1
0190 ACCHI *=*+1
0200 TURN *=*+1
0210 LAT *=*+1
0220 LONG *=*+1
0230 RFR *=*+1
0240 TRNTYP *=*+1
0250 SQVAL *=*+1
0260 ;
0270 ;OS locations (see OS manual)
0280 ;
0290 SDMCTL=$022F
0300 DLSTLO=$0230 Existing OS pointer to display list
0310 DLSTHI=$0231
0320 GPRIOR=$026F
0330 PCOLR0=$02C0
0340 ;
0350 ;HARDWARE LOCATIONS
0360 ;
0370 HPOSP0=$D000
0380 SIZEP0=$D008
0390 COLBAK=$D01A
0400 GRACTL=$D01D
0410 RANDOM=$D20A
0420 HSCROL=$D404
0430 VSCROL=$D405
0440 PMBASE=$D407
0450 NMIEN=$D40E
0460 SETVBV=$E45C
0470 ;
0480 ;Page 6 usage
0490 ;
0500  *=$0600
0510 ;first come locations used by the interrupt service routine
0520 XPOSL *=*+5 Horizontal position of screen window
0530 TRCOLR *=*+1
0540 EARTH *=*+1
0550 ICELAT *=*+1
0560 SEASN1 *=*+1
0570 SEASN2 *=*+1
0580 SEASN3 *=*+1
0590 DAY *=*+1
0600 MONTH *=*+1
0610 YEAR *=*+1
0620 BUTFLG *=*+1
0630 BUTMSK *=*+1
0640 ;
0650 ;THESE VALUES ARE USED BY MAINLINE ROUTINE ONLY
0660 ;
0670  *=$62A
0680 OLDLAT *=*+1
0690 TRNCOD *=*+1
0700 TLO *=*+1
0710 THI *=*+1
0720 TICK *=*+1
0730 UNTCOD *=*+1
0740 UNTCD1 *=*+1
0750 ;
0760 HANDCP=$68F
0770 ZOC=$694
0780 VICTRY=$697
0790 ;
0800 ;declarations of routines in other modules
0810 ;
0820 CHKZOC=$5140
0830 LOGSTC=$5091
0840 DNUMBR=$7BB2
0850 DWORDS=$79C0
0860 SWITCH=$79EF
0870 YINC=$7BF1
0880 XINC=$7BF2
0890 ;
0900  *=$5200
0910 PLYR0 *=*+512
0920 CORPSX *=*+159 x-coords of all units (pixel frame)
0930 CORPSY *=*+159 y-coords of all units (pixel frame)
0940 MSTRNG *=*+159 muster strengths
0950 CSTRNG *=*+159 combat strengths
0960 SWAP *=*+159 terrain code underneath unit
0970 ARRIVE *=*+159 turn of arrival
0980  *=$5C08
0990 ODIGIT *=*+256
1000 TXTTBL *=*+96 more text
1010 MONLEN *=*+13 table of month lengths
1020 HMORDS *=*+159 how many orders each unit has in queue
1030 WHORDS *=*+159 what the orders are
1040 WHORDH *=*+159
1050  *=$5FE2
1060 XADD *=*+4 offsets for moving arrow
1070 YADD *=*+4
1080 TRTAB *=*+13
1090 MLTKRZ *=*+8 maltese cross shape
1100 ;
1110  *=$6450
1120 TXTWDW *=$6CB1
1130 STKTAB *=*+16 a joystick decoding table
1140 SSNCOD *=*+12
1150 TRNTAB *=*+60
1160 BHX1 *=*+22
1170 BHY1 *=*+22
1180 BHX2 *=*+22
1190 BHY2 *=*+22
1200 EXEC *=*+159
1210 ;
1220 ;This is the initialization program
1230 ;The program begins here
1240 ;
1250  *=$6E00
1260 ;
1270  LDX #$08
1280 BOOP99 LDA ZPVAL,X initialize page zero values
1290  STA DLSTPT,X
1300  LDA COLTAB,X
1310  STA PCOLR0,X
1320  DEX
1330  BPL BOOP99
1340 ;
1350  LDX #$0F
1360 BOOP98 LDA PSXVAL,X initialize page six values
1370  STA XPOSL,X
1380  DEX
1390  BPL BOOP98
1400 ;
1410  LDA #$00
1420  STA DLSTLO
1430  STA HSCROL
1440  STA VSCROL
1450  LDA DLSTPT+1
1460  STA DLSTHI
1470 ;
1480  LDX #$00
1490 LOOP22 LDA MSTRNG,X
1500  STA CSTRNG,X
1510  LDA #$00
1520  STA HMORDS,X
1530  LDA #$FF
1540  STA EXEC,X
1550  INX
1560  CPX #$A0
1570  BNE LOOP22
1580 ;
1590 ;
1600 ;Now set up player window
1610 ;
1620  LDA #$50
1630  STA PMBASE
1640 ;
1650 ;here follow various initializations
1660 ;
1670  LDA #$2F
1680  STA SDMCTL
1690  LDA #$03
1700  STA GRACTL
1710  LDA #$78
1720  STA HPOSP0
1730  LDA #$01
1740  STA HANDCP
1750  STA GPRIOR
1760  STA SIZEP0
1770  LDX #$33
1780 ;
1790  LDA #$FF
1800  STA PLYR0,X
1810  INX
1820  STA PLYR0,X
1830  INX
1840  LDA #$81
1850 LOOP2 STA PLYR0,X
1860  INX
1870  CPX #$3F
1880  BNE LOOP2
1890  LDA #$FF
1900  STA PLYR0,X
1910  STA TURN
1920  INX
1930  STA PLYR0,X
1940 ;
1950 ;Now enable deferred vertical blank interrupt
1960 ;
1970  LDY #$00
1980  LDX #$74
1990  LDA #$07
2000  JSR SETVBV
2010  LDA #$00 This is DLI vector (low byte)
2020  STA $0200
2030  LDA #$7B
2040  STA $0201
2050  LDA #$C0
2060  STA NMIEN Turn interrupts on
2070 ;
2080 NEWTRN INC TURN
2090 ;
2100 ;first do calendar calculations
2110 ;
2120  LDA DAY
2130  CLC
2140  ADC #07
2150  LDX MONTH
2160  CMP MONLEN,X
2170  BEQ X28
2180  BCC X28
2190  CPX #$02
2200  BNE X96
2210  LDY YEAR
2220  CPY #44
2230  BNE X96
2240  SEC
2250  SBC #$01
2260 X96 SEC
2270  SBC MONLEN,X
2280  INX
2290  CPX #13
2300  BNE X29
2310  INC YEAR
2320  LDX #01
2330 X29 STX MONTH
2340  LDY TRTAB,X
2350  STY TRCOLR
2360 X28 STA DAY
2370  LDY #$93
2380  LDA #$00
2390 LOOP13 STA TXTWDW,Y
2400  INY
2410  CPY #$A7
2420  BNE LOOP13
2430  LDY #$93
2440  TXA
2450  CLC
2460  ADC #$10
2470  JSR DWORDS
2480  LDA DAY
2490  JSR DNUMBR
2500  LDA #$0C
2510  STA TXTWDW,Y
2520  INY
2530  INY
2540  LDA #$11
2550  STA TXTWDW,Y
2560  INY
2570  LDA #$19
2580  STA TXTWDW,Y
2590  INY
2600  LDX YEAR
2610  LDA #$14
2620  STA TXTWDW,Y
2630  INY
2640  LDA ODIGIT,X
2650  CLC
2660  ADC #$10
2670  STA TXTWDW,Y
2680 ;
2690 ;now do season calculations
2700 ;
2710  LDA MONTH
2720  CMP #$04
2730  BNE X87
2740  LDA #$02
2750  STA EARTH
2760  LDA #$40
2770  STA SEASN1
2780  LDA #$01
2790  STA SEASN3
2800  LDA #$00
2810  STA SEASN2
2820  JMP ENDSSN
2830 X87 CMP #$0A
2840  BNE X88
2850  LDA #$02
2860  STA EARTH
2870  JMP ENDSSN
2880 X88 CMP #$05
2890  BNE X89
2900  LDA #$10
2910  STA EARTH
2920  JMP ENDSSN
2930 X89 CMP #$0B
2940  BNE X90
2950  LDA #$0A
2960  STA EARTH
2970  JMP X91
2980 X90 CMP #$01
2990  BNE X92
3000  LDA #$80
3010  STA SEASN1
3020  LDA #$FF
3030  STA SEASN2
3040  STA SEASN3
3050  JMP ENDSSN
3060 X92 CMP #$03
3070  BEQ X91
3080  JMP ENDSSN
3090 ;
3100 ;
3110 ;freeze those rivers, baby
3120 ;
3130 X91 LDA RANDOM
3140  AND #$07
3150  CLC
3160  ADC #$07
3170  EOR SEASN2
3180  STA TEMPR
3190  LDA ICELAT
3200  STA OLDLAT
3210  SEC
3220  SBC TEMPR
3230  BEQ X95
3240  BPL X94
3250 X95 LDA #$01
3260 X94 CMP #$27
3270  BCC X93
3280  LDA #$27
3290 X93 STA ICELAT
3300  LDA #$01
3310  STA CHUNKX
3320  STA LONG
3330  LDA OLDLAT
3340  STA CHUNKY
3350  STA LAT
3360 ;
3370 LOOP40 JSR TERR
3380 ;
3390  AND #$3F
3400  CMP #$0B
3410  BCC NOTCH
3420  CMP #$29
3430  BCS NOTCH
3440  LDX CHUNKY
3450  CPX #$0E
3460  BCS DOTCH
3470  CMP #$23
3480  BCS NOTCH
3490 DOTCH ORA SEASN1
3500  LDX UNITNO
3510  BEQ X86
3520  STA SWAP,X
3530  JMP NOTCH
3540 X86 STA (MAPPTR),Y
3550 NOTCH INC CHUNKX
3560  LDA CHUNKX
3570  STA LONG
3580  CMP #46
3590  BNE LOOP40
3600  LDA #$00
3610  STA CHUNKX
3620  STA LONG
3630  LDA CHUNKY
3640  CMP ICELAT
3650  BEQ ENDSSN
3660  SEC
3670  SBC SEASN3
3680  STA CHUNKY
3690  STA LAT
3700  JMP LOOP40
3710 ;
3720 ENDSSN LDX #$9E any reinforcements?
3730 LOOP14 LDA ARRIVE,X
3740  CMP TURN
3750  BNE X33
3760  LDA CORPSX,X
3770  STA CHUNKX
3780  STA LONG
3790  LDA CORPSY,X
3800  STA CHUNKY
3810  STA LAT
3820  STX CORPS
3830  JSR TERRB
3840  BEQ SORRY
3850  CPX #$37
3860  BCS A51
3870  LDA #$0A
3880  STA TXTWDW+36
3890 A51 JSR SWITCH
3900  JMP X33
3910 SORRY LDA TURN
3920  CLC
3930  ADC #$01
3940  STA ARRIVE,X
3950 X33 DEX
3960  BNE LOOP14
3970 ;
3980 X31 LDX #$9E
3990 LOOPF STX ARMY
4000  JSR LOGSTC logistics subroutine
4010  LDX ARMY
4020  DEX
4030  BNE LOOPF
4040 ;
4050 ;calculate some points
4060 ;
4070  LDA #$00
4080  STA ACCLO
4090  STA ACCHI
4100  LDX #$01
4110 LOOPB LDA #$30
4120  SEC
4130  SBC CORPSX,X
4140  STA TEMPR
4150  LDA MSTRNG,X
4160  LSR A
4170  BEQ A01
4180  TAY
4190  LDA #$00
4200  CLC
4210 LOOPA ADC TEMPR
4220  BCC A0
4230  INC ACCHI
4240  CLC
4250  BNE A0
4260  DEC ACCHI
4270 A0 DEY
4280  BNE LOOPA
4290 A01 INX
4300  CPX #$37
4310  BNE LOOPB
4320 ;
4330 LOOPC LDA CORPSX,X
4340  STA TEMPR
4350  LDA CSTRNG,X
4360  LSR A
4370  LSR A
4380  LSR A
4390  BEQ A02
4400  TAY
4410  LDA #$00
4420  CLC
4430 LOOPD ADC TEMPR
4440  BCC A03
4450  INC ACCLO
4460  CLC
4470  BNE A03
4480  DEC ACCLO
4490 A03 DEY
4500  BNE LOOPD
4510 A02 INX
4520  CPX #$9E
4530  BNE LOOPC
4540 ;
4550  LDA ACCHI
4560  SEC
4570  SBC ACCLO
4580  BCS A04
4590  LDA #$00
4600 A04 LDX #$03
4610 LOOPG LDY MOSCOW,X
4620  BEQ A15
4630  CLC
4640  ADC MPTS,X
4650  BCC A15
4660  LDA #$FF
4670 A15 DEX
4680  BPL LOOPG
4690 ;
4700  LDX HANDCP was handicap option used?
4710  BNE A23 no
4720  LSR A yes, halve score
4730 A23 LDY #$05
4740  JSR DNUMBR
4750  LDA #$00
4760  STA TXTWDW,Y
4770  LDA TURN
4780  CMP #$28
4790  BNE Z00
4800  LDA #$01 end of game
4810  JSR TXTMSG
4820 FINI JMP FINI hang up
4830 ;
4840 ;
4850 Z00 LDA #$00
4860  STA BUTMSK
4870  STA CORPS
4880  JSR TXTMSG
4890  JSR $4700 artificial intelligence routine
4900  LDA #$01
4910  STA BUTMSK
4920  LDA #$02
4930  JSR TXTMSG
4940 ;
4950 ;movement execution phase
4960 ;
4970  LDA #$00
4980  STA TICK
4990  LDX #$9E
5000 LOOP31 STX ARMY
5010  JSR DINGO determine first execution time
5020  DEX
5030  BNE LOOP31
5040 ;
5050 LOOP33 LDX #$9E
5060 LOOP32 STX ARMY
5070  LDA MSTRNG,X
5080  SEC
5090  SBC CSTRNG,X
5100  CMP #$02
5110  BCC Y30
5120  INC CSTRNG,X
5130  CMP RANDOM
5140  BCC Y30
5150  INC CSTRNG,X
5160 Y30 LDA EXEC,X
5170  BMI A60
5180  CMP TICK
5190  BNE A60
5200  LDA WHORDS,X
5210  AND #$03
5220  TAY
5230  LDA CORPSX,X
5240  CLC
5250  ADC XINC,Y
5260  STA LONG
5270  STA ACCLO
5280  LDA CORPSY,X
5290  CLC
5300  ADC YINC,Y
5310  STA LAT
5320  STA ACCHI
5330  JSR TERR
5340  LDA UNITNO
5350  BEQ DOMOVE
5360  CMP #$37
5370  BCC GERMAN
5380  LDA ARMY
5390  CMP #$37
5400  BCS TRJAM
5410  BCC COMBAT
5420 GERMAN LDA ARMY
5430  CMP #$37
5440  BCS COMBAT
5450 TRJAM LDX ARMY
5460  LDA TICK
5470  CLC
5480  ADC #$02
5490  STA EXEC,X
5500 A60 JMP Y06
5510 COMBAT JSR $4ED8
5520  LDA VICTRY
5530  BEQ A60
5540  BNE Z94
5550 DOMOVE LDX ARMY
5560  STX CORPS
5570  LDA CORPSY,X
5580  STA CHUNKY
5590  STA LAT
5600  LDA CORPSX,X
5610  STA CHUNKX
5620  STA LONG
5630  JSR CHKZOC
5640  LDA ACCHI
5650  STA LAT
5660  LDA ACCLO
5670  STA LONG
5680  LDA ZOC
5690  CMP #$02
5700  BCC Z94
5710  JSR CHKZOC
5720  LDA ZOC
5730  CMP #$02
5740  BCS TRJAM
5750 Z94 JSR SWITCH
5760  LDX CORPS
5770  LDA LAT
5780  STA CHUNKY
5790  STA CORPSY,X
5800  LDA LONG
5810  STA CHUNKX
5820  STA CORPSX,X
5830  JSR SWITCH
5840  LDX ARMY
5850  LDA #$FF
5860  STA EXEC,X
5870  DEC HMORDS,X
5880  BEQ Y06
5890  LSR WHORDH,X
5900  ROR WHORDS,X
5910  LSR WHORDH,X
5920  ROR WHORDS,X
5930  LDY #$03
5940 LOOPH LDA CORPSX,X
5950  CMP MOSCX,Y
5960  BNE A18
5970  LDA CORPSY,X
5980  CMP MOSCY,Y
5990  BNE A18
6000  LDA #$FF
6010  CPX #$37
6020  BCC A19
6030  LDA #$00
6040 A19 STA MOSCOW,Y
6050 A18 DEY
6060  BPL LOOPH
6070 ;
6080  JSR DINGO
6090  JSR STALL
6100 Y06 LDX ARMY
6110  DEX
6120  BEQ Y07
6130  JMP LOOP32
6140 Y07 INC TICK
6150  LDA TICK
6160  CMP #$20
6170  BEQ Y08
6180  JMP LOOP33
6190 ;
6200 ;end of movement phase
6210 ;
6220 Y08 JMP NEWTRN
6230 ;
6240 MOSCOW .BYTE 0,0,0,0
6250 ;
6260  *=$7200
6270 STALL LDA #$00
6280 LOOP79 PHA
6290  PLA
6300  PHA
6310  PLA
6320  PHA
6330  PLA
6340  ADC #$01
6350  BNE LOOP79
6360  RTS
6370 ;
6380 ;this is the debugging routine
6390 ;it can't be reached by any route any longer
6400 ;
6410 ;
6420  *=$7210
6430  LDA #$00
6440  STA $D01D
6450  STA $D00D
6460  STA $D00E
6470  STA $D00F
6480  LDA #$22
6490  STA $22F
6500  LDA #$20
6510  STA $230
6520  LDA #$BC
6530  STA $231
6540  LDA #$40
6550  STA NMIEN
6560  LDA #$0A
6570  STA $2C5
6580  LDA #$00
6590  STA $5FFF
6600  STA $2C8
6610  BRK
6620 ;
6630 ;
6640 ;
6650 ;Subroutine TERR determines what terrain is in a square
6660 ;
6670  *=$7240
6680 ;
6690 TERR JSR TERRB
6700  BEQ LOOKUP
6710  RTS
6720 TERRB LDA #$00
6730  STA MAPPTR+1
6740  STA UNITNO
6750  LDA #$27
6760  SEC
6770  SBC LAT
6780  ASL A
6790  ROL MAPPTR+1
6800  ASL A
6810  ROL MAPPTR+1
6820  ASL A
6830  ROL MAPPTR+1
6840  ASL A
6850  ROL MAPPTR+1
6860  STA TLO
6870  LDY MAPPTR+1
6880  STY THI
6890  ASL A
6900  ROL MAPPTR+1
6910  CLC
6920  ADC TLO
6930  STA MAPPTR
6940  LDA MAPPTR+1
6950  ADC THI
6960  ADC #$65
6970  STA MAPPTR+1
6980  LDA #46
6990  SEC
7000  SBC LONG
7010  TAY
7020  LDA (MAPPTR),Y
7030  STA TRNCOD
7040  AND #$3F
7050  CMP #$3D
7060  BEQ A80
7070  CMP #$3E
7080 A80 RTS
7090 ;
7100 LOOKUP LDA TRNCOD
7110  STA UNTCOD
7120  AND #$C0
7130  LDX #$9E
7140  CMP #$40
7150  BNE X98
7160  LDX #$37
7170 X98 LDA LAT
7180 LOOP30 CMP CORPSY,X
7190  BEQ MIGHTB
7200 X97 DEX
7210  BNE LOOP30
7220  LDA #$FF
7230  STA TXTWDW+128
7240  BMI MATCH
7250 MIGHTB LDA LONG
7260  CMP CORPSX,X
7270  BNE X99
7280  LDA CSTRNG,X
7290  BEQ X99
7300  LDA ARRIVE,X
7310  BMI X99
7320  CMP TURN
7330  BCC MATCH
7340  BEQ MATCH
7350 X99 LDA LAT
7360  JMP X97
7370 MATCH STX UNITNO
7380  LDA SWAP,X
7390  STA TRNCOD
7400  RTS
7410 ;
7420 ;determines execution time of next move
7430 ;
7440 DINGO LDX ARMY
7450  LDA HMORDS,X
7460  BNE Y00
7470  LDA #$FF
7480  STA EXEC,X
7490  RTS
7500 Y00 LDA CORPSX,X
7510  STA LONG
7520  LDA CORPSY,X
7530  STA LAT
7540  JSR TERR
7550  LDA UNTCOD
7560  STA UNTCD1
7570  LDX ARMY
7580  LDA WHORDS,X
7590  EOR #$02
7600  AND #$03
7610  TAY
7620  LDA CORPSX,X
7630  CLC
7640  ADC XADD,Y
7650  STA LONG
7660  LDA CORPSY,X
7670  CLC
7680  ADC YADD,Y
7690  STA LAT
7700  JSR TERR
7710  JSR TERRTY
7720  LDA UNTCD1
7730  AND #$3F
7740  LDX #$00
7750  CMP #$3D
7760  BEQ Y01 infantry
7770  LDX #$0A armor
7780 Y01 TXA
7790  LDX MONTH
7800  CLC
7810  ADC SSNCOD-1,X add season index
7820  ADC TRNTYP add terrain index
7830  TAX
7840  LDA TRNTAB,X get net delay
7850  CLC
7860  ADC TICK
7870  LDX ARMY
7880  STA EXEC,X
7890  LDA TRNTYP
7900  CMP #$07
7910  BCC Y02
7920  LDY #$15
7930 LOOP35 LDA LAT
7940  CMP BHY1,Y
7950  BNE Y03
7960  LDA LONG
7970  CMP BHX1,Y
7980  BNE Y03
7990  LDX ARMY
8000  LDA CORPSX,X
8010  CMP BHX2,Y
8020  BNE Y03
8030  LDA CORPSY,X
8040  CMP BHY2,Y
8050  BNE Y03
8060  LDA #$FF
8070  STA EXEC,X
8080  RTS
8090 Y03 DEY
8100  BPL LOOP35
8110 Y02 RTS
8120 ;
8130 ;this subroutine determines the type of terrain
8140 ;in a square
8150 ;
8160 TERRTY LDY #$00
8170  LDA TRNCOD
8180  BEQ DONE
8190  CMP #$7F border?
8200  BNE Y04
8210  LDY #$09
8220  BNE DONE
8230 Y04 INY
8240  CMP #$07 mountain?
8250  BCC DONE
8260  INY
8270  CMP #$4B city?
8280  BCC DONE
8290  INY
8300  CMP #$4F frozen swamp?
8310  BCC DONE
8320  INY
8330  CMP #$69 frozen river?
8340  BCC DONE
8350  INY
8360  CMP #$8F swamp?
8370  BCC DONE
8380  INY
8390  CMP #$A4 river?
8400  BCC DONE
8410  LDX LAT
8420  CPX #$0E
8430  BCC NEXT
8440  CMP #$A9
8450  BCC DONE
8460 NEXT INY
8470  CMP #$BA coastline?
8480  BCC DONE
8490  CPX #$0E
8500  BCC NEXT2
8510  CMP #$BB
8520  BCC DONE
8530 NEXT2 INY
8540  CMP #$BD estuary?
8550  BCC DONE
8560  INY
8570 DONE STY TRNTYP
8580  RTS
8590 ZPVAL .BYTE 0,$64,0,0,0,$22,1,$30,2
8600 PSXVAL .BYTE $E0,0,0,$33,$78,$D6,$10,$27
8610  .BYTE $40,0,1,15,6,41,0,1
8620 COLTAB .BYTE $58,$DC,$2F,0,$6A,$C,$94,$46,$B0
8630 MPTS .BYTE 20,10,10,10
8640 MOSCX .BYTE 20,33,20,6
8650 MOSCY .BYTE 28,36,0,15
8660 TXTMSG ASL A
8670  ASL A
8680  ASL A
8690  ASL A
8700  ASL A
8710  TAX
8720  LDY #$69
8730 LOOP19 LDA TXTTBL,X
8740  SEC
8750  SBC #$20
8760  STA TXTWDW,Y
8770  INY
8780  INX
8790  TXA
8800  AND #$1F
8810  BNE LOOP19
8820  RTS
8830  .END

David Leaver                       10 Goodparla St,
e-mail leaver@netinfo.com.au       Hawker, ACT 2614
       leaver@alphalink.com.au     Australia